/*****************************************************
Project : Temprature Measurement with LM35
Author  : Reza Sepas Yar                      
Company : Pishro Noavaran Kavosh                            
Chip type           : ATmega16
Clock frequency     : 1.000000 MHz
*****************************************************/

#include <mega16.h>
#include <delay.h>
#include <stdio.h>
#define xtal 1000000

// Alphanumeric LCD Module functions
#asm
   .equ __lcd_port=0x12 ;PORTD
#endasm

#include <lcd.h>

#define ADC_VREF_TYPE 0xC0
// Read the AD conversion result
unsigned int read_adc(unsigned char adc_input)
{
ADMUX=adc_input|ADC_VREF_TYPE;
// Start the AD conversion
ADCSRA|=0x40;
// Wait for the AD conversion to complete
while ((ADCSRA & 0x10)==0);
ADCSRA|=0x10;
return ADCW;
}

void main(void)
{
 
char lcd_buff[10];
int adc_in;
float temp;

PORTA=0x00;
DDRA=0x00;

// ADC initialization
// ADC Clock frequency: 15.625 kHz
// ADC Voltage Reference: Int., cap. on AREF
// ADC Auto Trigger Source: None
ADMUX=ADC_VREF_TYPE;
ADCSRA=0x86;

// LCD module initialization
lcd_init(16);

while (1)
      {
      
      adc_in=read_adc(0);
      temp=adc_in/4;
      sprintf(lcd_buff,"Temp=%5.1f C",temp);
      lcd_clear();
      lcd_gotoxy(0,0);
      lcd_puts(lcd_buff);
      delay_ms(1000);
      
      };
}
