/***************************************************
Chip type           : ATmega16
Program type        : Application
Clock frequency     : 8.000000 MHz
Memory model        : Small
External SRAM size  : 0
Data Stack size     : 256
*****************************************************/
#include <mega16.h>
#include <delay.h>
#include <stdio.h>
#include <lcd.h>

#asm
   .equ __lcd_port=0x1B ;PORTA
#endasm

void main(void)
{ 
    char buffer[20];
    unsigned char w;

    PORTB=0xFF;
    DDRB=0x00;

    lcd_init(16);
    lcd_clear();
    lcd_putsf("Set Keys");
           		  
    while (1){
          
        w = ~PINB;
                     
        if(w!=0x00)
        {
            lcd_clear();
            lcd_gotoxy(0,0);                   
            sprintf(buffer,"Number=%d",w);    
            lcd_puts(buffer);
            delay_ms(100);
         }
         else
         {   
            lcd_clear();
            lcd_putsf("Number=0");
            delay_ms(100);
         }   
    }
}
