                 
#include <mega16.h> 
#include <delay.h> 
      
#define maxkeys 16

unsigned char key, butnum;   

//key pad scan table
flash unsigned char keytbl[16]={0xee, 0xed, 0xeb, 0xe7, 0xde, 0xdd, 0xdb, 0xd7, 0xbe, 0xbd, 0xbb, 0xb7, 0x7e, 0x7d, 0x7b, 0x77};

void main(void)
  {   
  //Init port B to show keyboard result
  DDRB = 0xff;
  PORTB = 0xff;      

  //endless loop to read keyboard
  while(1)
  	{ 
  	//get lower nibble
  	 DDRC = 0x0f;
  	 PORTC = 0xf0; 
  	 delay_us(5);
  	 key = PINC;
  	  
  	 //get upper nibble
  	 DDRC = 0xf0;
  	 PORTC = 0x0f; 
  	 delay_us(5);
  	 key = key | PINC;
  	  
  	 //find matching keycode in keytbl
  	 if (key != 0xff)
  	 {   
  	    for (butnum=0; butnum<maxkeys; butnum++)
  	    {    
  	        if (keytbl[butnum]==key)  break;   
  	    }
  	    if (butnum==maxkeys) butnum=0;
            else butnum++; //to make range 1-16
  	 }  
  	 else butnum=0;
  	 
  	 PORTB = ~ butnum ;
  	
  	} // end while
  }   //end main
